﻿//////////////////////////////////////////////
// DdsResourceMiscFlag.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkImages::dds
{
	enum class DDS_RESOURCE_MISC_FLAG : unsigned int
	{
		DDS_RESOURCE_MISC_FLAG_UNKNOWN = 0,
		DDS_MISC_TEXTURECUBE = 0x4
	} ;

	inline DDS_RESOURCE_MISC_FLAG operator& (DDS_RESOURCE_MISC_FLAG a, DDS_RESOURCE_MISC_FLAG b)
	{
		return (DDS_RESOURCE_MISC_FLAG)((unsigned int)a & (unsigned int)b) ;
	}

	inline DDS_RESOURCE_MISC_FLAG operator| (DDS_RESOURCE_MISC_FLAG a, DDS_RESOURCE_MISC_FLAG b)
	{
		return (DDS_RESOURCE_MISC_FLAG)((unsigned int)a | (unsigned int)b) ;
	}
}